///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DIALOGS_TABACCOUNT_CPP
#define _DIALOGS_TABACCOUNT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <PrSht.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabAccountDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hCompanyName     = NULL;
    static HWND hCompanyPwd      = NULL;
    static HWND hServerAddress   = NULL;
    static HWND hServerPort      = NULL;

    if(uMsg == WM_INITDIALOG)
    {
        hCompanyName     = GetDlgItem(hWnd, IDC_COMPANYNAME);
        hCompanyPwd      = GetDlgItem(hWnd, IDC_COMPANYPWD);

        hServerAddress   = GetDlgItem(hWnd, IDC_SERVERADDRESS);
        hServerPort      = GetDlgItem(hWnd, IDC_SERVERPORT);

        Set_Text(hCompanyName, gsCompanyName);
        Set_Text(hCompanyPwd, gsCompanyPassword);

        Set_Text(hServerAddress, gsServerAddress);
        Set_Long(hServerPort, gdwServerPort);

        return TRUE;
    }

    if(uMsg == WM_COMMAND)
    {

        return FALSE;
    }

    if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            char lsCompanyName[64 + 1];
            int liCompanyNameLen = Get_TextEx(hCompanyName, lsCompanyName, 64);
            if(liCompanyNameLen == 0 || liCompanyNameLen > 64)
            {
                MessageBox(hWnd, "You must enter a valid company name. Between 1 and 64 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsCompanyPwd[64 + 1];
            int liCompanyPwdLen = Get_TextEx(hCompanyPwd, lsCompanyPwd, 64);
            if(liCompanyPwdLen == 0 || liCompanyPwdLen > 64)
            {
                MessageBox(hWnd, "You must enter a valid company password. Between 1 and 64 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsServerAddress[255 + 1];
            int liServerAddressLen = Get_TextEx(hServerAddress, lsServerAddress, 255);
            if(liServerAddressLen == 0 || liServerAddressLen > 255)
            {
                MessageBox(hWnd, "You must enter a valid server address. Between 1 and 255 characters.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            int liServerPort = Get_Long(hServerPort);
            if(liServerPort == 0 || liServerPort > 65535)
            {
                MessageBox(hWnd, "You must enter a valid server port. Between 1 and 65,535.", gsTitleCaption, MB_ICONASTERISK);
                SetWindowLongPtr(hWnd, DWLP_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy_s(gsCompanyName, sizeof(lsCompanyName), lsCompanyName);
            strcpy_s(gsCompanyPassword, sizeof(lsCompanyPwd), lsCompanyPwd);
            strcpy_s(gsServerAddress, sizeof(lsServerAddress), lsServerAddress);

            gdwServerPort = liServerPort;

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
